//
//  PeopleAppDelegate.m
//  People
//
//  Created by Jonathan Diehl on 09.01.10.
//  Copyright RWTH 2010. All rights reserved.
//

#import "PeopleAppDelegate.h"
#import "RootViewController.h"

#define PEOPLE_LOADER_URL @"http://127.0.0.1:3000/people.xml"


@implementation PeopleAppDelegate

@synthesize window;


#pragma mark -
#pragma mark Application lifecycle

- (void)applicationDidFinishLaunching:(UIApplication *)application {    
    
	// start loading people
	peopleLoader = [[PeopleLoader alloc] initWithURL:[NSURL URLWithString:PEOPLE_LOADER_URL]];
	peopleLoader.delegate = self;
	
	// show loading view
	[window addSubview:viewLoading];
    [window makeKeyAndVisible];

	// load people data in background
	[peopleLoader load];
}


- (void)applicationWillTerminate:(UIApplication *)application {
	// Save data if appropriate
}


#pragma mark -
#pragma mark Memory management

- (void)dealloc {
	[peopleLoader release];
	[navigationController release];
	[viewLoading release];
	[window release];
	[super dealloc];
}


# pragma mark -
# pragma mark PeopleLoaderDelegate

// loading done
- (void)peopleLoader:(PeopleLoader *)aPeopleLoader didLoadPeople:(NSArray *)people
{
	// create view controllers
	RootViewController *rootViewController = [[RootViewController alloc] initWithPeople:people];
	navigationController = [[UINavigationController alloc] initWithRootViewController:rootViewController];
	[rootViewController release];
	
	// remove loading view
	[viewLoading removeFromSuperview];
	[viewLoading release];
	viewLoading = nil;
	
	// show navigation controller
	[window addSubview:navigationController.view];
	
	
	// cleanup
	[peopleLoader release];
	peopleLoader = nil;
}

// loading failed
- (void)peopleLoader:(PeopleLoader *)peopleLoader didFailWithError:(NSError *)error
{
	NSString *message = [NSString stringWithFormat:@"Could not load people data (%@)", [error domain]];
	UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Connection Error" 
														message:message 
													   delegate:self 
											  cancelButtonTitle:@"Try again" 
											  otherButtonTitles:nil];
	[alertView show];
	[alertView release];
}


# pragma mark -
# pragma mark UIAlertViewDelegate

// alert view closed
- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex;
{
	// try again
	[peopleLoader load];
}

@end

